VERSION 5.00
Begin VB.Form frmEZScan_VISA 
   Caption         =   "Form1"
   ClientHeight    =   3600
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   3600
   ScaleWidth      =   5250
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtReadings 
      Height          =   3135
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "frmEZScan_VISA.frx":0000
      Top             =   240
      Width           =   2175
   End
   Begin VB.CommandButton cmdScan 
      Caption         =   "Start Scan"
      Height          =   855
      Left            =   2640
      TabIndex        =   0
      Top             =   240
      Width           =   2295
   End
End
Attribute VB_Name = "frmEZScan_VISA"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
''    Copyright  2002 Agilent Technologies Inc. All rights
''    reserved.
''
'' You have a royalty-free right to use, modify, reproduce and distribute
'' the Sample Application Files (and/or any modified version) in any way
'' you find useful, provided that you agree that Agilent has no
'' warranty,  obligations or liability for any Sample Application Files.
''
'' Agilent Technologies provides programming examples for illustration only,
'' This sample program assumes that you are familiar with the programming
'' language being demonstrated and the tools used to create and debug
'' procedures. Agilent support engineers can help explain the
'' functionality of Agilent software components and associated
'' commands, but they will not modify these samples to provide added
'' functionality or construct procedures to meet your specific needs.
'' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'
' This code implements a simple scan with the 34970A using the Agilent SICL IO
' Library.
'

Const DAQ_ADDRESS = "GPIB::9"

Dim DAQ As Long


Private Sub cmdScan_Click()
' initialize io object set the functions and then scan
    Dim readings() As Double
    Dim cmd As String
    Dim strTemp As String * 256
    Dim strArray() As String
    Dim actual As Long
    Dim i As Long

    initialize_IO
    
    ' Stop any ongoing scan
    cmd = "Abort"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)

    ' reset instrument
    cmd = "*rst"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)

    ' configure for DC and Resistance
    cmd = "Conf:volt:DC Auto,(@101,102);:Volt:DC:NPLC 0.02,(@101,102)"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    cmd = "Conf:Res Auto,(@106:108);:Res:NPLC 0.02,(@106:108)"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    cmd = "Route:Scan (@101,102,106:108)"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    
    ' determine the size of the scan
    ' This value is not used
    cmd = "Rout:Scan:Size?"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    Call viRead(DAQ, strTemp, 255, actual)
    
    ' initialize and wait for the scan to complete
    cmd = "INIT"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    cmd = "*OPC?"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    Call viRead(DAQ, strTemp, 255, actual)

    cmd = "Fetch?"
    Call viWrite(DAQ, cmd & Chr$(10), Len(cmd) + 1, actual)
    Call viRead(DAQ, strTemp, 255, actual)
    strTemp = Left$(strTemp, actual - 1)

    strArray = Split(strTemp, ",")
    ReDim readings(UBound(strArray))
    For i = 0 To UBound(strArray)
        readings(i) = Val(strArray(i))
    Next i
    

With txtReadings
    .Text = ""
    .SelText = Now & vbCrLf
    For i = 0 To UBound(readings)
        .SelText = readings(i) & vbCrLf
    Next i
End With


End Sub

' initializes the GPIB port
Public Sub initialize_IO()
    Dim viDefaultRM As Long
    Dim status As Long
    
    On Error GoTo VisaErrorHandler

    status = viOpenDefaultRM(viDefaultRM)
    status = viOpen(viDefaultRM, DAQ_ADDRESS, 0, 10000, DAQ)
    If (status < VI_SUCCESS) Then GoTo VisaErrorHandler



    Exit Sub
VisaErrorHandler:
    Dim strVisaErr As String * 200
    Call viStatusDesc(viDefaultRM, status, strVisaErr)
    MsgBox "*** Error : " & strVisaErr, vbExclamation, "VISA Error Message"
End Sub




